set linesize 32000
set pagesize 1000
set echo on
set termout on
set trimspool on

spool subpartitionstats2.log

select * from v$version;

drop table SUBPARTAB;

CREATE TABLE SUBPARTAB 
( 
SUBPART_COL     NUMBER(4)          NOT NULL,
PART_COL        DATE               NOT NULL,
MISC_DATA       NUMBER
)
 PARTITION BY RANGE (PART_COL)
 SUBPARTITION BY LIST (SUBPART_COL)
 SUBPARTITION TEMPLATE
  (SUBPARTITION SUB_1  VALUES (1),
   SUBPARTITION SUB_2  VALUES (2),
   SUBPARTITION SUB_DEFAULT VALUES (DEFAULT)
  )
(  
  PARTITION PART_20120101 VALUES LESS THAN (TO_DATE('2012-01-01', 'YYYY-MM-DD')),  
  PARTITION PART_20120201 VALUES LESS THAN (TO_DATE('2012-02-01', 'YYYY-MM-DD'))  
);

insert into SUBPARTAB values (1,TO_DATE('2012-01-02', 'YYYY-MM-DD'),1);
insert into SUBPARTAB values (2,TO_DATE('2012-01-02', 'YYYY-MM-DD'),1);

commit;

select partition_name,subpartition_name,num_rows,last_analyzed from user_tab_subpartitions where table_name='SUBPARTAB';

execute dbms_stats.gather_table_stats(NULL,'SUBPARTAB','PART_20120201_SUB_1',granularity=>'SUBPARTITION');

select partition_name,subpartition_name,num_rows,last_analyzed from user_tab_subpartitions where table_name='SUBPARTAB';

spool off
