set linesize 1000
set pagesize 1000
set echo on
set termout on

spool chain3.log

set timing on

select /* comment to force hard parse */ count(*) from T1;

VARIABLE monitored_sid number;

begin

SELECT sid into :monitored_sid from v$session where audsid=USERENV('SESSIONID');

end;
/

-- show library cache lock wait time in seconds

SELECT TIME_WAITED/100 "Library cache lock in seconds"
FROM V$SESSION_EVENT a, V$SESSION b
WHERE 
a.SID = b.SID and
a.SID= :monitored_sid and
a.event='library cache lock';

spool off
