#!/bin/ksh

DELPHIX_SERVER=YOURSERVERNAME
CLI_USER=delphix_admin

#VDB=${ORACLE_SID}
VDB=$1

if [[ -n $VDB ]];then
  echo "VDB is $VDB"
else 
  echo "Oracle SID is not passed as a parameter.  Using ORACLE_SID env "
  VDB=${ORACLE_SID}
  echo "VDB is $VDB"
fi

echo "Get dSource for $VDB"

DSOURCE=`ssh $CLI_USER@$DELPHIX_SERVER "cd database ; select $VDB ; ls " |grep parentContainer: | awk '{print $2;}'`;

echo "DSOURCE = $DSOURCE"

SCN=`ssh $CLI_USER@$DELPHIX_SERVER "cd snapshot ; list database=$DSOURCE" | tail -n 1 |awk '{print $3;}'`; 

echo "SCN = $SCN"

echo "Refreshing the $VDB - progress at /tmp/refresh_$VDB"

ssh $CLI_USER@$DELPHIX_SERVER "cd database ; select $VDB ; refresh ; set timeflowPoint.timeflow=$DSOURCE ; set timeflowPoint.location=$SCN ; commit; " > /tmp/refresh_$VDB

echo "Refresh complete."
whoami
